#!/bin/bash

# 1 - Wineversion
# 2 - Patchname (ex: wine-1.3.25-patch)

# Si patchname n'est pas spécifié, alors patchname prend le nom de wineversion

patchName="$1"
customName="$2"
[ "$WINEGIT" = "" ] && WINEGIT="git"

build_dir="$HOME/wine-patches/$bt/$patchName"
all_dir="$HOME/wine-patches/$bt/all"
custom_dir="$HOME/wine-patches/custom/$customName"

if [ -e "$custom_dir" -a ! "$2" = "" ] 
then
        cd "$HOME/wine-$WINEGIT"

        for file in "$custom_dir/"*".patch"
        do
                echo "[PATCH] Patching custom: $file"
		if [ -e "$custom_dir/winebuild.cfg" ]
		then
			echo "Reading winebuild.cfg" 
			level="$(cat "$custom_dir/winebuild.cfg" | grep patch_level | cut -d"=" -f2)"
			if [ "$level" = "" ]
			then
				echo "[PATCH] patch_level not set."
			elif [ "$level" = "-1" ]
			then
				echo "[PATCH] level set to -1, using git apply"
				git apply "$file"
				patched="true"
			else
				echo "[PATCH] patch_level : $level"
				patch -p$level < "$file" 
				patched="true"
			fi
		else
			echo "[PATCH] winebuild.cfg not found"
		fi
        done
	cd "$HOME/wine-tools"
       for file in "$custom_dir/"*".patch"
        do
                echo "[PATCH] Patching custom: $file"
                if [ -e "$custom_dir/winebuild.cfg" ]
                then
                        echo "Reading winebuild.cfg"
                        level="$(cat "$custom_dir/winebuild.cfg" | grep patch_level | cut -d"=" -f2)"
                        if [ "$level" = "" ]
                        then
                                echo "[PATCH] patch_level not set."
                        elif [ "$level" = "-1" ]
                        then
                                echo "[PATCH] level set to -1, using git apply"
                                git apply "$file"
                                patched="true"
                        else
                                echo "[PATCH] patch_level : $level"
                                patch -p$level < "$file"
                                patched="true"
                        fi
                else
                        echo "[PATCH] winebuild.cfg not found"
                fi
        done

	cd "$HOME/wine-$WINEGIT"
        if [ -e "$custom_dir/commands.cfg" ]
        then
                echo "Running $custom_dir/commands.cfg"
                bash $custom_dir/commands.cfg
                echo "Done."
        fi
        if [ -e "$custom_dir/source.cfg" ]
        then
                echo "Source $custom_dir/source.cfg"
                source $custom_dir/source.cfg
                echo "Done."
        fi

fi

if [ -e "$build_dir" ] 
then
        cd "$HOME/wine-$WINEGIT"

        for file in "$build_dir/"*".patch"
        do
                echo "[PATCH] Patching custom: $file"
		if [ -e "$build_dir/winebuild.cfg" ]
		then
			echo "Reading winebuild.cfg" 
			level="$(cat "$build_dir/winebuild.cfg" | grep patch_level | cut -d"=" -f2)"
			if [ "$level" = "" ]
			then
				echo "[PATCH] patch_level not set."
			elif [ "$level" = "-1" ]
			then
				echo "[PATCH] level set to -1, using git apply"
				git apply "$file"
				patched="true"
			else
				echo "[PATCH] patch_level : $level"
				patch -p$level < "$file" 
				patched="true"
			fi
		else
			echo "[PATCH] winebuild.cfg not found"
		fi
        done
	cd "$HOME/wine-tools"
       for file in "$build_dir/"*".patch"
        do
                echo "[PATCH] Patching custom: $file"
                if [ -e "$build_dir/winebuild.cfg" ]
                then
                        echo "Reading winebuild.cfg"
                        level="$(cat "$build_dir/winebuild.cfg" | grep patch_level | cut -d"=" -f2)"
                        if [ "$level" = "" ]
                        then
                                echo "[PATCH] patch_level not set."
                        elif [ "$level" = "-1" ]
                        then
                                echo "[PATCH] level set to -1, using git apply"
                                git apply "$file"
                                patched="true"
                        else
                                echo "[PATCH] patch_level : $level"
                                patch -p$level < "$file"
                                patched="true"
                        fi
                else
                        echo "[PATCH] winebuild.cfg not found"
                fi
        done

	cd "$HOME/wine-$WINEGIT"
        if [ -e "$build_dir/commands.cfg" ]
        then
                echo "Running $build_dir/commands.cfg"
                bash $build_dir/commands.cfg
                echo "Done."
        fi
        if [ -e "$build_dir/source.cfg" ]
        then
                echo "Source $custom_dir/source.cfg"
                source $build_dir/source.cfg
                echo "Done."
        fi

fi



if [ -e "$all_dir" ] 
then
        cd "$HOME/wine-$WINEGIT"

        for file in "$all_dir/"*".patch"
        do
                echo "[PATCH] Patching custom: $file"
		if [ -e "$all_dir/winebuild.cfg" ]
		then
			echo "Reading winebuild.cfg" 
			level="$(cat "$all_dir/winebuild.cfg" | grep patch_level | cut -d"=" -f2)"
			if [ "$level" = "" ]
			then
				echo "[PATCH] patch_level not set."
			elif [ "$level" = "-1" ]
			then
				echo "[PATCH] level set to -1, using git apply"
				git apply "$file"
				patched="true"
			else
				echo "[PATCH] patch_level : $level"
				patch -p$level < "$file" 
				patched="true"
			fi
		else
			echo "[PATCH] winebuild.cfg not found"
		fi
        done
	cd "$HOME/wine-tools"
       for file in "$all_dir/"*".patch"
        do
                echo "[PATCH] Patching custom: $file"
                if [ -e "$all_dir/winebuild.cfg" ]
                then
                        echo "Reading winebuild.cfg"
                        level="$(cat "$all_dir/winebuild.cfg" | grep patch_level | cut -d"=" -f2)"
                        if [ "$level" = "" ]
                        then
                                echo "[PATCH] patch_level not set."
                        elif [ "$level" = "-1" ]
                        then
                                echo "[PATCH] level set to -1, using git apply"
                                git apply "$file"
                                patched="true"
                        else
                                echo "[PATCH] patch_level : $level"
                                patch -p$level < "$file"
                                patched="true"
                        fi
                else
                        echo "[PATCH] winebuild.cfg not found"
                fi
        done

	cd "$HOME/wine-$WINEGIT"
        if [ -e "$all_dir/commands.cfg" ]
        then
                echo "Running $all_dir/commands.cfg"
                bash $all_dir/commands.cfg
                echo "Done."
        fi
        if [ -e "$all_dir/source.cfg" ]
        then
                echo "Source $custom_dir/source.cfg"
                source $all_dir/source.cfg
                echo "Done."
        fi

fi
exit 0
