#!/bin/bash
#amd64 / x86
source social.sh

#export CCACHE_DIR="$HOME/ccache"
[ "$1" = "" ] && exit
[ "$1" = "--custom-list" ] && clist=true && shift



if [ ! -e "make.$1.sh" ]
then
	echo "Building module $1 not supported"
	exit
fi 
export bt="$1"
[ -e $HOME/build.lock ] && echo "Already running, exiting" && exit
touch $HOME/build.lock

if [ x$1 = "x--init" ] ; then
	git clone git://source.winehq.org/git/wine.git $HOME/wine-git
	mkdir -p $HOME/binaries/i386
	mkdir -p $HOME/binaries/amd64
	rm $HOME/build.lock
	echo "Init. Done."
	exit
fi

cd $HOME/wine-git/

bash $HOME/winebuild/makeClean.sh

git reset --hard FETCH_HEAD
git pull


cd $HOME/wine-tools/
git reset --hard FETCH_HEAD
git pull

cd $HOME/wine-git
if [ ! "$clist" == "true" ]
then
git tag | grep "wine-1.2" > $HOME/listTags
git tag | grep "wine-1.3" >> $HOME/listTags
git tag | grep "wine-1.4" >> $HOME/listTags
git tag | grep "wine-1.5" >> $HOME/listTags
git tag | grep "wine-1.6" >> $HOME/listTags
git tag | grep "wine-1.7" >> $HOME/listTags
fi

gecko_current="$HOME/current_gecko"
gecko_file="$HOME/wine/gecko/gecko.lst"

mono_current="$HOME/current_mono"
mono_file="$HOME/wine/mono/mono.lst"

while read version
do
	[ -e $HOME/binaries/$bt/PlayOnLinux-$version-$bt.pol ] && continue
	cVer=${version:5}
	if ! grep -q "^$cVer;" $gecko_file; then GECKO="`cat $gecko_current`";  echo "$cVer;$GECKO" >> $gecko_file; fi
	if ! grep -q "^$cVer;" $mono_file; then MONO="`cat $mono_current`";  echo "$cVer;$MONO" >> $mono_file; fi
	if [ "$(cat $HOME/ignore.lst | grep $version-$bt)" = "" ]
	then
	send-to-irc playonlinux-staff "[Winebuild $bt] Running make.$bt.sh $version"
	sleep 2	
	nohup /bin/bash $HOME/winebuild/make.$bt.sh $version > $HOME/logs/$bt/$version-$bt.log 2> $HOME/logs/$bt/$version-$bt.err
	send-to-irc playonlinux-staff "[Winebuild $bt] Exit code : $?"
	nohup /bin/bash $HOME/winebuild/makeClean.sh 2>&1 >> $HOME/logs/$bt/$version-$bt.log
	fi
done < $HOME/listTags

rm "$HOME/build.lock"
exit 