#!/bin/bash

[ "$2" = "" ] && exit 0 || patchSuff="-$2"
touch $HOME/build.lock

version="$1"
patchname="$2"

source "../wine-patches/custom/$patchname/winebuild.cfg"
export FRAMEWORK="10.5"
cd "$HOME/wine-tools"
git pull
git reset --hard $1
make clean
./configure $ConfigureArgs
make depend || exit 102
cd $HOME/winebuild
python updateMakeFile.py /home/winebuild/wine-tools/tools/winegcc/Makefile || exit 103

cd $HOME/wine-tools/libs/port 
make clean || exit 104
make || exit 105
cd $HOME/wine-tools/libs/wine
make clean || exit 106
make || exit 107
cd $HOME/wine-tools/libs/wpp
make clean || exit 108
make || exit 109
cd $HOME/wine-tools/tools
make clean || exit 110
make || exit 111
cd $HOME/wine-tools/tools/winegcc
make clean || exit 112
make || exit 113
cd $HOME/wine-tools/tools/widl
make clean || exit 114
make || exit 115
cd $HOME/wine-tools/tools/winebuild
make clean || exit 116
make || exit 117
cd $HOME/wine-tools/tools/winedump
make clean || exit 118
make || exit 119
cd $HOME/wine-tools/tools/wmc
make clean || exit 120
make || exit 121
cd $HOME/wine-tools/tools/wrc
make clean || exit 122
make || exit 123
#
#
cd $HOME/wine-tools
make __tooldeps__

export PATH="/usr/i686-apple-darwin10/bin/:$PATH"
export CC="i686-apple-darwin10-gcc -m32 -iframework/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/System/Library/Frameworks -isysroot /usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk -m32"

#export LDFLAGS="-L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib -L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib/system  -I/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib/gcc/i686-apple-darwin10/4.0.1/include/ -L/usr/i686-apple-darwin10/usr/local/lib -I/usr/i686-apple-darwin10/usr/local/include -I/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/X11/include/ -L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/X11/lib/"
export LDFLAGS="-L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib -L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib/system  -I/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib/gcc/i686-apple-darwin10/4.0.1/include/ -L/usr/i686-apple-darwin10/usr/local/lib -I/usr/i686-apple-darwin10/usr/local/include -I/usr/i686-apple-darwin10/opt/X11/include/ -I/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/X11/include/ -L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/X11/lib/"

export CPPFLAGS="$LDFLAGS"
export CXXFLAGS="-arch i386 -m32"
export CFLAGS="-arch i386 -m32"

cd $HOME/wine-dev
git reset --hard $1
git pull
export WINEGIT="dev"
cd $HOME/winebuild
bash applyPatches.sh "$1" "$2" || exit 230 
WV=${1:5}

cd "$HOME/wine-dev"
./configure --prefix=/ --host=i686-apple-darwin10  --with-wine-tools=$HOME/wine-tools $ConfigureArgs || exit 1

make || exit 2
mkdir -p $HOME/wine-custom/darwin-x86/$1$patchSuff/wineversion/${WV}$patchSuff/
make install DESTDIR=$HOME/wine-custom/darwin-x86/$1$patchSuff/wineversion/${WV}$patchSuff/ || exit 3

cd $HOME/wine-custom/darwin-x86/$1$patchSuff/
rm -rf wineversion/${WV}$patchSuff/include/
find -type f -exec strip -s '{}' +

cd $HOME/wine-custom/darwin-x86/
tar czvf $1$patchSuff.tar.bz2 $1$patchSuff/


