#!/bin/bash

[ "$2" = "" ] && exit 0 || patchSuff="-$2"

version="$1"
patchname="$2"

CC="gcc-4.4 -m32"
LDFLAGS="-m32 -L/lib32 -L/usr/lib32 -Wl,-rpath,/lib32 -Wl,-rpath,/usr/lib32"

cd $HOME/wine-dev
git reset --hard $1

export WINEGIT="dev"
cd $HOME/winebuild
bash applyPatches.sh "$1" "$2" || exit 230 
WV=${1:5}

cd "$HOME/wine-dev"
./configure --prefix=/ || exit 1

make || exit 2
mkdir -p $HOME/wine-custom/linux-x86/$1$patchSuff/wineversion/${WV}$patchSuff/
make install DESTDIR=$HOME/wine-custom/linux-x86/$1$patchSuff/wineversion/${WV}$patchSuff/ || exit 3

cd $HOME/wine-custom/linux-x86/$1$patchSuff/
rm -rf wineversion/${WV}$patchSuff/include/
find -type f -exec strip -s '{}' +

cd $HOME/wine-custom/linux-x86/
tar czvf $1$patchSuff.tar.bz2 $1$patchSuff/


