#!/bin/bash
echo "Regenerating lists"
cd "$HOME/binaries"
for arch in *
do

cd "$HOME/binaries/$arch" 2> /dev/null 
if [ "$?" = 0 ]
then
echo "Entering $HOME/binaries/$arch"
touch ../$arch.lst
if [ ! "$(ls)" = "" ] 
then
for file in *
do
if [ ! "$file" = "LIST" ] && [ ! "$file" = "LIST_" ] && [ ! "$(echo $file | awk -F . '{print $NF}')" = "sha1" ]
then
version=$(echo "$file"| sed 's/PlayOnMac-wine-//')
version=$(echo "$version"| sed 's/PlayOnLinux-wine-//')
version=$(echo $version | sed "s/-$arch.pol//")
version=$(echo $version | sed "s/-$arch.pom//")
echo $file
sha1=$(sha1sum $file | cut -d " " -f1)
echo "$file;$version;$sha1" >> LIST_

fi
done
mv LIST_ ../$arch.lst
python "$HOME/winebuild/pSort.py" $HOME/binaries/$arch.lst
fi
fi
done
