#!/bin/bash
source "$HOME/winebuild/social.sh"

export WV=${1:5}
[ "$2" = "" ] || patchSuff="-$2"

cd $HOME/wine/$bt/$1$patchSuff/
send-to-irc playonlinux-staff "[Winebuild $bt $1$patchSuff] Making POL package"
rm -rf wineversion/${WV}$patchSuff/include/
find -type f -exec strip -s '{}' +
mkdir playonlinux files
cat <<EOF > playonlinux/main
#!/bin/bash
if [ "\$PLAYONLINUX" = "" ]
then   
        exit 0
fi

source "\$PLAYONLINUX/lib/sources" 

cp -a \$SCRIPT_DIRECTORY/../wineversion/${WV}$patchSuff \$REPERTOIRE/wine/$bt/${WV}$patchSuff

exit
EOF
cp "$HOME/wine-libs/$bt/"* wineversion/${WV}$patchSuff/lib/
tar jcf $HOME/binaries/$bt/PlayOnLinux-$1$patchSuff-$bt.pol *
cd ../
#rm -rf "$1"
cd $HOME/binaries/$bt/
shasum PlayOnLinux-$1$patchSuff-$bt.pol > PlayOnLinux-$1$patchSuff-$bt.pol.sha1
cd $HOME/winebuild
[ "$4" = "noList" ] || bash buildList.sh
#[ "$3" = "noSend" ] || sendMsg "$1$patchSuff"

#[ "$3" = "noSend" ] || addToNews "$1$patchSuff"
