#!/bin/bash
bash "$HOME/winebuild/setState" "$1" "$2"

[ "$2" = "" ] || patchSuff="-$2"
source $HOME/winebuild/social.sh

addToNews "$1$patchSuff" "- Mac OS X amd64 building started at $(cdate)"

# export FRAMEWORK="10.4u" # On compile sous Tiger
# export FRAMEWORK="10.6" # Sous snow finalement
export FRAMEWORK="10.6"



send-to-irc playonlinux-staff "[Winebuild $bt $1] Building wine tools for linux"
cd "$HOME/wine-tools"
send-to-irc playonlinux-staff "[Winebuild $bt $1] tools - Reading git"
git reset --hard $1
send-to-irc playonlinux-staff "[Winebuild $bt $1] tools - Cleaning"

make clean
send-to-irc playonlinux-staff "[Winebuild $bt $1] tools - fast ./configure"
./configure
send-to-irc playonlinux-staff "[Winebuild $bt $1] tools Make depend" 
make depend || exit 102
send-to-irc playonlinux-staff "[Winebuild $bt $1] tools Updating makefile" 
cd $HOME/winebuild
python updateMakeFile.py /home/winebuild/wine-tools/tools/winegcc/Makefile || exit 103
send-to-irc playonlinux-staff "[Winebuild $bt $1] Bulding tools" # Dans le bon ordre, c'est assez important
cd $HOME/wine-tools/libs/port 
make clean || exit 104
make || exit 105
cd $HOME/wine-tools/libs/wine
make clean || exit 106
make || exit 107
cd $HOME/wine-tools/libs/wpp
make clean || exit 108
make || exit 109
cd $HOME/wine-tools/tools
make clean || exit 110
make || exit 111
cd $HOME/wine-tools/tools/winegcc
make clean || exit 112
make || exit 113
cd $HOME/wine-tools/tools/widl
make clean || exit 114
make || exit 115
cd $HOME/wine-tools/tools/winebuild
make clean || exit 116
make || exit 117
cd $HOME/wine-tools/tools/winedump
make clean || exit 118
make || exit 119
cd $HOME/wine-tools/tools/wmc
make clean || exit 120
make || exit 121
cd $HOME/wine-tools/tools/wrc
make clean || exit 122
make || exit 123
#
#
cd $HOME/wine-tools
make __tooldeps__

sleep 2
send-to-irc playonlinux-staff "[Winebuild $bt $1] Tools are built"
sleep 2
send-to-irc playonlinux-staff "[Winebuild $bt $1] Setting Mac OS $FRAMEWORK cross building framework"


# Je note juste en commentaire les etapes (qui ne marchent pas encore)

export PATH="/usr/i686-apple-darwin10/bin/:$PATH"
export CC="i686-apple-darwin10-gcc -iframework/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/System/Library/Frameworks -isysroot /usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk"

#export LDFLAGS="-L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib -L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib/system  -I/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib/gcc/i686-apple-darwin10/4.0.1/include/ -L/usr/i686-apple-darwin10/usr/local/lib -I/usr/i686-apple-darwin10/usr/local/include -I/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/X11/include/ -L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/X11/lib/"
export LDFLAGS="-L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib -L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib/system  -I/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/lib/gcc/i686-apple-darwin10/4.0.1/include/ -L/usr/i686-apple-darwin10/usr/local/lib -I/usr/i686-apple-darwin10/usr/local/include -I/usr/i686-apple-darwin10/opt/X11/include/ -I/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/X11/include/ -L/usr/lib/apple/SDKs/MacOSX$FRAMEWORK.sdk/usr/X11/lib/"

export CPPFLAGS="$LDFLAGS"
export CXXFLAGS=""
export CFLAGS=""


# Et ya encore du boulot ça plante encore au make. Je suis pas couché
echo "[darwin.sh] STARTING BUILD ($1) AT: $(date -R)"
send-to-irc playonlinux-staff "[Winebuild $bt] STARTING BUILD ($1) AT : $(date -R)"

source $HOME/winebuild/social.sh

cd $HOME/wine-git
send-to-irc playonlinux-staff "[Winebuild $bt $1] Reading git"
git reset --hard $1
echo git reset --hard $1
cd $HOME/winebuild
bash applyPatches.sh "$1" "$2" || exit 230 

# [ "$APPLY_WINETOOLE" = "TRUE" ] && env WINEGIT="wine-tools" bash applyPatches.sh "$1" "$2" || exit 231


cd $HOME/wine-git
WV=${1:5}

mkdir pol_amd64
mkdir pol_x86

send-to-irc playonlinux-staff "[Winebuild $bt $1] ./configure 64 bits"
./configure --prefix=/ --host=i686-apple-darwin10  --with-wine-tools=$HOME/wine-tools --enable-win64  || exit 1
send-to-irc playonlinux-staff "[Winebuild $bt $1] make 64 bits"
make || exit 2
cd ..
cd pol_x86
send-to-irc playonlinux-staff "[Winebuild $bt $1] ./configure 32 bits"
../configure --host=i686-apple-darwin10 --prefix=/ --with-wine64=../pol_amd64 || exit 3
send-to-irc playonlinux-staff "[Winebuild $bt $1] make 32 bits"
make || exit 4
cd ..


mkdir -p $HOME/wine/darwin-x86/$1$patchSuff/wineversion/${WV}$patchSuff/
cd pol_x86
send-to-irc playonlinux-staff "[Winebuild $bt $1] make install 32 bits"
make install DESTDIR=$HOME/wine/$bt/$1$patchSuff/wineversion/${WV}$patchSuff/ || exit 5
cd ..
cd pol_amd64
send-to-irc playonlinux-staff "[Winebuild $bt $1] make install 64 bits"
make install DESTDIR=$HOME/wine/$bt/$1$patchSuff/wineversion/${WV}$patchSuff/ || exit 6

send-to-irc playonlinux-staff "[Winebuild $bt $1] Successfully build $1 !"

cd $HOME/winebuild
bash buildPackage.sh "$1" "$2"
#curl --ftp-ssl --insecure --upload-file PlayOnLinux-$1.pol --user poladmin:Kq89NODW ftp://mulx.playonlinux.com/wine/linux-i386/
#curl --ftp-ssl --insecure --upload-file PlayOnLinux-$1.pol.sha1 --user poladmin:Kq89NODW ftp://mulx.playonlinux.com/wine/linux-i386/
#wget -O LIST "http://wine.playonlinux.com/linux-i386/LIST"
#touch LIST
#cat LIST | grep -v ";$WV;" > PlayOnLinux.lst
#echo "PlayOnLinux-$1.pol;$WV;" >> PlayOnLinux.lst
#python $HOME/pSort.py
#curl --ftp-ssl --insecure --upload-file LIST --user poladmin:Kq89NODW ftp://mulx.playonlinux.com/wine/linux-i386/
#sendMsg "${1:5}"

echo "[darwin.sh] END PACKAGE AT: $(date -R)"

send-to-irc playonlinux-staff "[Winebuild $bt $1] END package $1"
bash setState "ready"
addToNews "$1$patchSuff" "- Mac OS X amd64 building finished at $(cdate)"
exit 0
