#!/bin/bash
bash "$HOME/winebuild/setState" "$1" "$2"
CC="ccache gcc"
[ "$2" = "" ] || patchSuff="-$2"

echo "[$1] STARTING BUILD ($1) AT: $(date -R)"
send-to-irc playonlinux-staff "[Winebuild $bt $1] STARTING BUILD ($1) AT : $(date -R)"

source $HOME/winebuild/social.sh
addToNews "$1$patchSuff" "- Linux amd64 building started at $(cdate)"

cd $HOME/wine-git
send-to-irc playonlinux-staff "[Winebuild $bt $1] Reading GIT"
git reset --hard $1

cd $HOME/winebuild
bash applyPatches.sh "$1" "$2" || exit 230
cd $HOME/wine-git

WV=${1:5}

mkdir pol_amd64
mkdir pol_x86


send-to-irc playonlinux-staff "[Winebuild $bt $1] ./configure 64 bits"
cd pol_amd64

make distclean
../configure --prefix=/ --enable-win64 || exit 1
send-to-irc playonlinux-staff "[Winebuild $bt $1] make 64 bits"
make -j 4 || exit 2
cd ..
cd pol_x86
send-to-irc playonlinux-staff "[Winebuild $bt $1] ./configure 32 bits"
../configure --host=x86_64-linux-gnu --build=x86_64-linux-gnu --prefix=/ --with-wine64=../pol_amd64 || exit 3
send-to-irc playonlinux-staff "[Winebuild $bt $1] make 32 bits"
make -j 4 || exit 4
cd ..
mkdir -p $HOME/wine/$bt/$1$patchSuff/wineversion/${WV}$patchSuff/
cd pol_x86
send-to-irc playonlinux-staff "[Winebuild $bt $1] make install 32 bits"
make install DESTDIR=$HOME/wine/$bt/$1$patchSuff/wineversion/${WV}$patchSuff/ || exit 5
cd ..
cd pol_amd64
send-to-irc playonlinux-staff "[Winebuild $bt $1] make install 64 bits"
make install DESTDIR=$HOME/wine/$bt/$1$patchSuff/wineversion/${WV}$patchSuff/ || exit 6

cd $HOME/winebuild
bash buildPackage.sh "$1" "$2"
#curl --ftp-ssl --insecure --upload-file PlayOnLinux-$1.pol --user poladmin:Kq89NODW ftp://mulx.playonlinux.com/wine/linux-i386/
#curl --ftp-ssl --insecure --upload-file PlayOnLinux-$1.pol.sha1 --user poladmin:Kq89NODW ftp://mulx.playonlinux.com/wine/linux-i386/
#wget -O LIST "http://wine.playonlinux.com/linux-i386/LIST"
#touch LIST
#cat LIST | grep -v ";$WV;" > PlayOnLinux.lst
#echo "PlayOnLinux-$1.pol;$WV;" >> PlayOnLinux.lst
#python $HOME/pSort.py
#curl --ftp-ssl --insecure --upload-file LIST --user poladmin:Kq89NODW ftp://mulx.playonlinux.com/wine/linux-i386/
#sendMsg "${1:5}"

echo "[$bt] END PACKAGE AT: $(date -R)"
bash setState "$1"
send-to-irc playonlinux-staff "[Winebuild $bt $1] END PACKAGE"
addToNews "$1$patchSuff" "- Linux amd64 building finished at $(cdate)"

exit 0
