#!/bin/bash
sh "$HOME/winebuild/setState" "$1" "$2"
[ "$2" = "" ] || patchSuff="-$2"

source $HOME/winebuild/social.sh
addToNews "$1$patchSuff" "- Linux i386 building started at $(cdate)"
echo "[$bt.sh] STARTING BUILD ($1) AT: $(date -R)"
send-to-irc playonlinux-staff "[Winebuild $bt] STARTING BUILD ($1) AT : $(date -R)"

source $HOME/winebuild/social.sh

#export CFLAGS=""
#export CXXFLAGS="$CFLAGS"
CC="ccache gcc-4.4 -m32" 
LDFLAGS="-m32 -L/lib32 -L/usr/lib32 -Wl,-rpath,/lib32 -Wl,-rpath,/usr/lib32"
cd $HOME/wine-git
send-to-irc playonlinux-staff "[Winebuild $bt $1] Reading git"
git reset --hard $1
echo git reset --hard $1

cd $HOME/winebuild
bash applyPatches.sh "$1" "$2" || exit 230
cd $HOME/wine-git

WV=${1:5}
send-to-irc playonlinux-staff "[Winebuild $bt $1] ./configure"
./configure --prefix=/ || exit 1
send-to-irc playonlinux-staff "[Winebuild $bt $1] make"
make -j 4 || exit 2
mkdir -p $HOME/wine/$bt/$1$patchSuff/wineversion/${WV}$patchSuff/
send-to-irc playonlinux-staff "[Winebuild $bt $1] make install"
make install DESTDIR=$HOME/wine/$bt/$1$patchSuff/wineversion/${WV}$patchSuff/ || exit 3
send-to-irc playonlinux-staff "[Winebuild $bt $1] Making POL package"

cd $HOME/winebuild
bash buildPackage.sh "$1" "$2"
#curl --ftp-ssl --insecure --upload-file PlayOnLinux-$1.pol --user poladmin:Kq89NODW ftp://mulx.playonlinux.com/wine/linux-i386/
#curl --ftp-ssl --insecure --upload-file PlayOnLinux-$1.pol.sha1 --user poladmin:Kq89NODW ftp://mulx.playonlinux.com/wine/linux-i386/
#wget -O LIST "http://wine.playonlinux.com/linux-i386/LIST"
#touch LIST
#cat LIST | grep -v ";$WV;" > PlayOnLinux.lst
#echo "PlayOnLinux-$1.pol;$WV;" >> PlayOnLinux.lst
#python $HOME/pSort.py
#curl --ftp-ssl --insecure --upload-file LIST --user poladmin:Kq89NODW ftp://mulx.playonlinux.com/wine/linux-i386/
#sendMsg "${1:5}"

echo "[$bt] END PACKAGE AT: $(date -R)"
bash setState "ready"
send-to-irc playonlinux-staff "[Winebuild $bt $1] END package $1"
addToNews "$1$patchSuff" "- Linux i386 building finished at $(cdate)"

exit 0
