#!/bin/bash
#amd64 / x86
[ "$1" = "" ] && exit
if [ ! -e "make.$1.sh" ]
then
	echo "Building module $1 not supported"
	exit
fi 
export bt="$1"
export wb_patching="true"
[ -e $HOME/build.lock ] && echo "Already running, exiting" && exit
touch $HOME/build.lock

cd $HOME/wine-git/

bash $HOME/winebuild/makeClean.sh

git reset --hard FETCH_HEAD
git pull


cd $HOME/wine-tools/
git reset --hard FETCH_HEAD
git pull

cd $HOME/wine-git
while read line
do
	version="$(echo $line | awk '{print $1}')"
	patchname="$(echo $line | awk '{print $2}')"
	[ -e $HOME/binaries/$bt/PlayOnLinux-$version-$patchname-$bt.pol ] && continue
	send-to-irc playonlinux-staff "[Winebuild $bt] Running make.$bt.sh $version $patchname"
	sleep 2	
	nohup /bin/bash $HOME/winebuild/make.$bt.sh $version $patchname > $HOME/logs/$bt/$version-$patchname-$bt.log 2> $HOME/logs/$bt/$version-$patchname-$bt.err
	send-to-irc playonlinux-staff "[Winebuild $bt] Exit code : $?"
	nohup /bin/bash $HOME/winebuild/makeClean.sh 2>&1 >> $HOME/logs/$bt/$version-$patchname-$bt.log

done < $HOME/wine-patches/custom/todo_$bt.lst

rm "$HOME/build.lock"
exit
